# Released under the MIT License. See LICENSE for details.
#
"""Common shared Ballistica components.

For modding purposes, this package should generally not be used
directly. Instead one should use purpose-built packages such as
:mod:`bascenev1` or :mod:`bauiv1` which themselves import various
functionality from here and reexpose it in a more focused way.
"""
# pylint: disable=redefined-builtin

# ba_meta require api 9

# The stuff we expose here at the top level is our 'public' api for use
# from other modules/packages. Code *within* this package should import
# things from this package's submodules directly to reduce the chance of
# dependency loops. The exception is TYPE_CHECKING blocks and
# annotations since those aren't evaluated at runtime.

import _babase
from _babase import (
    add_clean_frame_callback,
    allows_ticket_sales,
    android_get_external_files_dir,
    app_instance_uuid,
    appname,
    appnameupper,
    apptime,
    apptimer,
    AppTimer,
    atexit,
    asset_loads_allowed,
    fullscreen_control_available,
    fullscreen_control_get,
    fullscreen_control_key_shortcut,
    fullscreen_control_set,
    can_display_chars,
    charstr,
    clipboard_get_text,
    clipboard_has_text,
    clipboard_is_supported,
    clipboard_set_text,
    ContextCall,
    ContextRef,
    displaytime,
    displaytimer,
    DisplayTimer,
    do_once,
    env,
    Env,
    fade_screen,
    fatal_error,
    get_display_resolution,
    get_immediate_return_code,
    get_input_idle_time,
    get_low_level_config_value,
    get_max_graphics_quality,
    get_replays_dir,
    get_string_height,
    get_string_width,
    get_suppress_config_and_state_writes,
    get_ui_scale,
    get_v1_cloud_log_file_path,
    get_virtual_safe_area_size,
    get_virtual_screen_size,
    getsimplesound,
    has_user_run_commands,
    have_permission,
    in_logic_thread,
    in_main_menu,
    increment_analytics_count,
    request_main_ui,
    is_os_playing_music,
    is_xcode_build,
    lock_all_input,
    mac_music_app_get_playlists,
    mac_music_app_get_volume,
    mac_music_app_init,
    mac_music_app_play_playlist,
    mac_music_app_set_volume,
    mac_music_app_stop,
    menu_press,
    music_player_play,
    music_player_set_volume,
    music_player_shutdown,
    music_player_stop,
    native_review_request,
    native_review_request_supported,
    native_stack_trace,
    open_file_externally,
    open_url,
    overlay_web_browser_close,
    overlay_web_browser_is_open,
    overlay_web_browser_is_supported,
    overlay_web_browser_open_url,
    print_load_info,
    pushcall,
    quit,
    reload_hooks,
    reload_media,
    request_permission,
    safecolor,
    screenmessage,
    set_analytics_screen,
    set_low_level_config_value,
    set_thread_name,
    set_main_ui_input_device,
    set_account_sign_in_state,
    set_ui_scale,
    show_progress_bar,
    shutdown_suppress_begin,
    shutdown_suppress_end,
    shutdown_suppress_count,
    SimpleSound,
    suppress_config_and_state_writes,
    supports_max_fps,
    supports_vsync,
    supports_unicode_display,
    unlock_all_input,
    update_internal_logger_levels,
    user_agent_string,
    user_ran_commands,
    Vec3,
    workspaces_in_use,
)

from babase._accountv2 import AccountV2Handle, AccountV2Subsystem
from babase._app import App, AppState
from babase._appcomponent import AppComponentSubsystem
from babase._appconfig import commit_app_config
from babase._appintent import AppIntent, AppIntentDefault, AppIntentExec
from babase._appmode import AppMode
from babase._appsubsystem import AppSubsystem
from babase._appmodeselector import AppModeSelector
from babase._appconfig import AppConfig
from babase._apputils import (
    handle_leftover_v1_cloud_log_file,
    is_browser_likely_available,
    get_remote_app_name,
    AppHealthSubsystem,
    utc_now_cloud,
)
from babase._cloud import CloudSubscription
from babase._devconsole import (
    DevConsoleButtonDef,
    DevConsoleTab,
    DevConsoleTabEntry,
    DevConsoleSubsystem,
)
from babase._discord import DiscordSubsystem
from babase._emptyappmode import EmptyAppMode
from babase._error import (
    ContextError,
    NotFoundError,
    PlayerNotFoundError,
    SessionPlayerNotFoundError,
    NodeNotFoundError,
    ActorNotFoundError,
    InputDeviceNotFoundError,
    WidgetNotFoundError,
    ActivityNotFoundError,
    TeamNotFoundError,
    MapNotFoundError,
    SessionTeamNotFoundError,
    SessionNotFoundError,
    DelegateNotFoundError,
)
from babase._gc import GarbageCollectionSubsystem
from babase._general import (
    DisplayTime,
    AppTime,
    WeakCall,
    Call,
    existing,
    Existable,
    verify_object_death,
    storagename,
    getclass,
    get_type_name,
)
from babase._language import Lstr, LanguageSubsystem
from babase._locale import LocaleSubsystem
from babase._logging import (
    balog,
    accountlog,
    applog,
    lifecyclelog,
    netlog,
    uilog,
)
from babase._login import LoginAdapter, LoginInfo

from babase._mgen.enums import (
    Permission,
    SpecialChar,
    InputType,
    UIScale,
    QuitType,
)
from babase._math import normalized_color, is_point_in_box, vec3validate
from babase._meta import MetadataSubsystem
from babase._env import DEFAULT_REQUEST_TIMEOUT_SECONDS
from babase._net import get_ip_address_type, NetworkSubsystem
from babase._plugin import PluginSpec, Plugin, PluginSubsystem
from babase._stringedit import StringEditAdapter, StringEditSubsystem
from babase._text import timestring
from babase._workspace import WorkspaceSubsystem

_babase.app = app = App()

__all__ = [
    'accountlog',
    'AccountV2Handle',
    'AccountV2Subsystem',
    'ActivityNotFoundError',
    'ActorNotFoundError',
    'allows_ticket_sales',
    'add_clean_frame_callback',
    'android_get_external_files_dir',
    'app',
    'App',
    'AppComponentSubsystem',
    'AppConfig',
    'AppHealthSubsystem',
    'AppIntent',
    'AppIntentDefault',
    'AppIntentExec',
    'AppMode',
    'AppState',
    'app_instance_uuid',
    'applog',
    'appname',
    'appnameupper',
    'AppModeSelector',
    'AppSubsystem',
    'apptime',
    'AppTime',
    'apptime',
    'apptimer',
    'AppTimer',
    'asset_loads_allowed',
    'atexit',
    'balog',
    'Call',
    'fullscreen_control_available',
    'fullscreen_control_get',
    'fullscreen_control_key_shortcut',
    'fullscreen_control_set',
    'can_display_chars',
    'charstr',
    'clipboard_get_text',
    'clipboard_has_text',
    'clipboard_is_supported',
    'CloudSubscription',
    'clipboard_set_text',
    'commit_app_config',
    'ContextCall',
    'ContextError',
    'ContextRef',
    'DelegateNotFoundError',
    'DevConsoleButtonDef',
    'DevConsoleTab',
    'DevConsoleTabEntry',
    'DevConsoleSubsystem',
    'DiscordSubsystem',
    'DisplayTime',
    'displaytime',
    'displaytimer',
    'DisplayTimer',
    'do_once',
    'EmptyAppMode',
    'env',
    'Env',
    'Existable',
    'existing',
    'fade_screen',
    'fatal_error',
    'GarbageCollectionSubsystem',
    'get_display_resolution',
    'get_immediate_return_code',
    'get_input_idle_time',
    'get_ip_address_type',
    'get_low_level_config_value',
    'get_max_graphics_quality',
    'get_remote_app_name',
    'get_replays_dir',
    'get_string_height',
    'get_string_width',
    'get_suppress_config_and_state_writes',
    'get_type_name',
    'get_ui_scale',
    'get_virtual_safe_area_size',
    'get_virtual_screen_size',
    'get_v1_cloud_log_file_path',
    'getclass',
    'getsimplesound',
    'handle_leftover_v1_cloud_log_file',
    'has_user_run_commands',
    'have_permission',
    'in_logic_thread',
    'in_main_menu',
    'increment_analytics_count',
    'InputDeviceNotFoundError',
    'InputType',
    'request_main_ui',
    'is_browser_likely_available',
    'is_browser_likely_available',
    'is_os_playing_music',
    'is_point_in_box',
    'is_xcode_build',
    'LanguageSubsystem',
    'LocaleSubsystem',
    'lifecyclelog',
    'lock_all_input',
    'LoginAdapter',
    'LoginInfo',
    'Lstr',
    'mac_music_app_get_playlists',
    'mac_music_app_get_volume',
    'mac_music_app_init',
    'mac_music_app_play_playlist',
    'mac_music_app_set_volume',
    'mac_music_app_stop',
    'MapNotFoundError',
    'menu_press',
    'MetadataSubsystem',
    'music_player_play',
    'music_player_set_volume',
    'music_player_shutdown',
    'music_player_stop',
    'native_review_request',
    'native_review_request_supported',
    'native_stack_trace',
    'netlog',
    'NetworkSubsystem',
    'NodeNotFoundError',
    'normalized_color',
    'NotFoundError',
    'open_file_externally',
    'open_url',
    'overlay_web_browser_close',
    'overlay_web_browser_is_open',
    'overlay_web_browser_is_supported',
    'overlay_web_browser_open_url',
    'Permission',
    'PlayerNotFoundError',
    'Plugin',
    'PluginSubsystem',
    'PluginSpec',
    'print_load_info',
    'pushcall',
    'quit',
    'QuitType',
    'reload_hooks',
    'reload_media',
    'request_permission',
    'safecolor',
    'screenmessage',
    'SessionNotFoundError',
    'SessionPlayerNotFoundError',
    'SessionTeamNotFoundError',
    'set_analytics_screen',
    'set_low_level_config_value',
    'set_main_ui_input_device',
    'set_thread_name',
    'set_account_sign_in_state',
    'set_ui_scale',
    'show_progress_bar',
    'shutdown_suppress_begin',
    'shutdown_suppress_end',
    'shutdown_suppress_count',
    'SimpleSound',
    'suppress_config_and_state_writes',
    'SpecialChar',
    'storagename',
    'StringEditAdapter',
    'StringEditSubsystem',
    'supports_max_fps',
    'supports_vsync',
    'supports_unicode_display',
    'TeamNotFoundError',
    'timestring',
    'uilog',
    'UIScale',
    'unlock_all_input',
    'update_internal_logger_levels',
    'user_agent_string',
    'user_ran_commands',
    'utc_now_cloud',
    'Vec3',
    'vec3validate',
    'verify_object_death',
    'WeakCall',
    'WidgetNotFoundError',
    'workspaces_in_use',
    'WorkspaceSubsystem',
    'DEFAULT_REQUEST_TIMEOUT_SECONDS',
]

# We want stuff to show up as babase.Foo instead of babase._sub.Foo.
# UPDATE: Trying without this for now. Seems like this might cause more
# harm than good. Can flip it back on if it is missed.
# set_canonical_module_names(globals())

# Allow the native layer to wrap a few things up.
_babase.reached_end_of_babase()

# Marker we pop down at the very end so other modules can run sanity
# checks to make sure we aren't importing them reciprocally when they
# import us.
_REACHED_END_OF_MODULE = True
