# Released under the MIT License. See LICENSE for details.
#
"""Ballistica user interface api version 1"""

# ba_meta require api 9

# The stuff we expose here at the top level is our 'public' api.
# It should only be imported by code outside of this package or
# from 'if TYPE_CHECKING' blocks (which will not exec at runtime).
# Code within our package should import things directly from their
# submodules.

from __future__ import annotations

# pylint: disable=redefined-builtin

import logging

from babase import (
    accountlog,
    AccountV2Handle,
    add_clean_frame_callback,
    allows_ticket_sales,
    app,
    App,
    AppIntent,
    AppIntentDefault,
    AppIntentExec,
    AppMode,
    applog,
    appname,
    appnameupper,
    apptime,
    AppState,
    AppTime,
    apptimer,
    AppTimer,
    asset_loads_allowed,
    balog,
    Call,
    DevConsoleButtonDef,
    DevConsoleTab,
    DevConsoleTabEntry,
    DevConsoleSubsystem,
    fullscreen_control_available,
    fullscreen_control_get,
    fullscreen_control_key_shortcut,
    fullscreen_control_set,
    charstr,
    clipboard_is_supported,
    clipboard_set_text,
    commit_app_config,
    CloudSubscription,
    ContextRef,
    displaytime,
    DisplayTime,
    displaytimer,
    DisplayTimer,
    do_once,
    existing,
    fade_screen,
    get_display_resolution,
    get_input_idle_time,
    get_ip_address_type,
    get_low_level_config_value,
    get_max_graphics_quality,
    get_remote_app_name,
    get_replays_dir,
    get_string_height,
    get_string_width,
    get_type_name,
    get_virtual_safe_area_size,
    get_virtual_screen_size,
    getclass,
    have_permission,
    in_logic_thread,
    in_main_menu,
    increment_analytics_count,
    is_browser_likely_available,
    is_xcode_build,
    lock_all_input,
    LoginAdapter,
    LoginInfo,
    Lstr,
    native_review_request,
    native_review_request_supported,
    netlog,
    NotFoundError,
    open_file_externally,
    open_url,
    overlay_web_browser_close,
    overlay_web_browser_is_open,
    overlay_web_browser_is_supported,
    overlay_web_browser_open_url,
    Permission,
    Plugin,
    PluginSpec,
    pushcall,
    quit,
    QuitType,
    request_main_ui,
    request_permission,
    safecolor,
    screenmessage,
    set_analytics_screen,
    set_low_level_config_value,
    set_main_ui_input_device,
    shutdown_suppress_begin,
    shutdown_suppress_end,
    SpecialChar,
    supports_max_fps,
    supports_vsync,
    supports_unicode_display,
    timestring,
    uilog,
    UIScale,
    unlock_all_input,
    utc_now_cloud,
    WeakCall,
    workspaces_in_use,
)

from _bauiv1 import (
    buttonwidget,
    checkboxwidget,
    columnwidget,
    containerwidget,
    get_qrcode_texture,
    get_selected_widget,
    get_special_widget,
    getmesh,
    getsound,
    gettexture,
    hscrollwidget,
    imagewidget,
    Mesh,
    reload_hooks,
    root_ui_pause_updates,
    root_ui_resume_updates,
    rowwidget,
    scrollwidget,
    set_party_window_open,
    spinnerwidget,
    Sound,
    Texture,
    textwidget,
    uibounds,
    Widget,
    widget,
    widget_by_id,
)
from bauiv1._keyboard import Keyboard
from bauiv1._uitypes import (
    uicleanupcheck,
    RootUIUpdatePause,
)
from bauiv1._appsubsystem import UIV1AppSubsystem
from bauiv1._window import (
    Window,
    MainWindowState,
    BasicMainWindowState,
    MainWindow,
    MainWindowAutoRecreateSuppress,
)

__all__ = [
    'accountlog',
    'AccountV2Handle',
    'add_clean_frame_callback',
    'allows_ticket_sales',
    'app',
    'App',
    'AppIntent',
    'AppIntentDefault',
    'AppIntentExec',
    'AppMode',
    'applog',
    'appname',
    'appnameupper',
    'appnameupper',
    'AppState',
    'apptime',
    'AppTime',
    'apptimer',
    'AppTimer',
    'asset_loads_allowed',
    'balog',
    'BasicMainWindowState',
    'buttonwidget',
    'Call',
    'DevConsoleButtonDef',
    'DevConsoleTab',
    'DevConsoleTabEntry',
    'DevConsoleSubsystem',
    'fullscreen_control_available',
    'fullscreen_control_get',
    'fullscreen_control_key_shortcut',
    'fullscreen_control_set',
    'charstr',
    'checkboxwidget',
    'clipboard_is_supported',
    'clipboard_set_text',
    'columnwidget',
    'commit_app_config',
    'containerwidget',
    'CloudSubscription',
    'ContextRef',
    'displaytime',
    'DisplayTime',
    'displaytimer',
    'DisplayTimer',
    'do_once',
    'existing',
    'fade_screen',
    'get_display_resolution',
    'get_input_idle_time',
    'get_ip_address_type',
    'get_low_level_config_value',
    'get_max_graphics_quality',
    'get_qrcode_texture',
    'get_remote_app_name',
    'get_replays_dir',
    'get_selected_widget',
    'get_special_widget',
    'get_string_height',
    'get_string_width',
    'get_type_name',
    'get_virtual_safe_area_size',
    'get_virtual_screen_size',
    'getclass',
    'getmesh',
    'getsound',
    'gettexture',
    'have_permission',
    'hscrollwidget',
    'imagewidget',
    'in_logic_thread',
    'in_main_menu',
    'increment_analytics_count',
    'is_browser_likely_available',
    'is_xcode_build',
    'Keyboard',
    'lock_all_input',
    'LoginAdapter',
    'LoginInfo',
    'Lstr',
    'MainWindow',
    'MainWindowAutoRecreateSuppress',
    'MainWindowState',
    'Mesh',
    'native_review_request',
    'native_review_request_supported',
    'netlog',
    'NotFoundError',
    'open_file_externally',
    'open_url',
    'overlay_web_browser_close',
    'overlay_web_browser_is_open',
    'overlay_web_browser_is_supported',
    'overlay_web_browser_open_url',
    'Permission',
    'Plugin',
    'PluginSpec',
    'pushcall',
    'quit',
    'QuitType',
    'reload_hooks',
    'request_main_ui',
    'request_permission',
    'root_ui_pause_updates',
    'root_ui_resume_updates',
    'RootUIUpdatePause',
    'rowwidget',
    'safecolor',
    'screenmessage',
    'scrollwidget',
    'set_analytics_screen',
    'set_low_level_config_value',
    'set_party_window_open',
    'set_main_ui_input_device',
    'shutdown_suppress_begin',
    'shutdown_suppress_end',
    'Sound',
    'SpecialChar',
    'spinnerwidget',
    'supports_max_fps',
    'supports_vsync',
    'supports_unicode_display',
    'Texture',
    'textwidget',
    'timestring',
    'uibounds',
    'uicleanupcheck',
    'uilog',
    'UIScale',
    'UIV1AppSubsystem',
    'unlock_all_input',
    'utc_now_cloud',
    'WeakCall',
    'widget',
    'widget_by_id',
    'Widget',
    'Window',
    'workspaces_in_use',
]

# Sanity check: we want to keep ballistica's dependencies and
# bootstrapping order clearly defined; let's check a few particular
# modules to make sure they never directly or indirectly import us
# before their own execs complete.
if __debug__:
    for _mdl in 'babase', '_babase':
        if not hasattr(__import__(_mdl), '_REACHED_END_OF_MODULE'):
            logging.warning(
                '%s was imported before %s finished importing;'
                ' should not happen.',
                __name__,
                _mdl,
            )
