# Released under the MIT License. See LICENSE for details.
"""Enum vals generated by batools.enumspython; do not edit by hand."""

from enum import Enum


class InputType(Enum):
    """Types of input a controller can send to the game."""

    UP_DOWN = 2
    LEFT_RIGHT = 3
    JUMP_PRESS = 4
    JUMP_RELEASE = 5
    PUNCH_PRESS = 6
    PUNCH_RELEASE = 7
    BOMB_PRESS = 8
    BOMB_RELEASE = 9
    PICK_UP_PRESS = 10
    PICK_UP_RELEASE = 11
    RUN = 12
    FLY_PRESS = 13
    FLY_RELEASE = 14
    START_PRESS = 15
    START_RELEASE = 16
    HOLD_POSITION_PRESS = 17
    HOLD_POSITION_RELEASE = 18
    LEFT_PRESS = 19
    LEFT_RELEASE = 20
    RIGHT_PRESS = 21
    RIGHT_RELEASE = 22
    UP_PRESS = 23
    UP_RELEASE = 24
    DOWN_PRESS = 25
    DOWN_RELEASE = 26


class QuitType(Enum):
    """Types of quit behavior that can be requested from the app.

    'soft' may hide/reset the app but keep the process running, depending
       on the platform (generally a thing on mobile).

    'back' is a variant of 'soft' which may give 'back-button-pressed'
       behavior depending on the platform. (returning to some previous
       activity instead of dumping to the home screen, etc.)

    'hard' leads to the process exiting. This generally should be avoided
       on platforms such as mobile where apps are expected to keep running
       until killed by the OS.
    """

    SOFT = 0
    BACK = 1
    HARD = 2


class UIScale(Enum):
    """The overall scale the UI is being rendered for. Note that this is
    independent of pixel resolution. For example, a phone and a desktop PC
    might render the game at similar pixel resolutions but the size they
    display content at will vary significantly.

    'large' is used for devices such as desktop PCs where fine details can
       be clearly seen. UI elements are generally smaller on the screen
       and more content can be seen at once.

    'medium' is used for devices such as tablets, TVs, or VR headsets.
       This mode strikes a balance between clean readability and amount of
       content visible.

    'small' is used primarily for phones or other small devices where
       content needs to be presented as large and clear in order to remain
       readable from an average distance.
    """

    SMALL = 0
    MEDIUM = 1
    LARGE = 2


class Permission(Enum):
    """Permissions that can be requested from the OS."""

    STORAGE = 0


class SpecialChar(Enum):
    """Special characters the engine can diplay. Note that this currently
    needs to be manually kept in sync with bacommon.text.SpecialChar.
    """

    DOWN_ARROW = 0
    UP_ARROW = 1
    LEFT_ARROW = 2
    RIGHT_ARROW = 3
    TOP_BUTTON = 4
    LEFT_BUTTON = 5
    RIGHT_BUTTON = 6
    BOTTOM_BUTTON = 7
    DELETE = 8
    SHIFT = 9
    BACK = 10
    LOGO_FLAT = 11
    REWIND_BUTTON = 12
    PLAY_PAUSE_BUTTON = 13
    FAST_FORWARD_BUTTON = 14
    DPAD_CENTER_BUTTON = 15
    PLAY_STATION_CROSS_BUTTON = 16
    PLAY_STATION_CIRCLE_BUTTON = 17
    PLAY_STATION_TRIANGLE_BUTTON = 18
    PLAY_STATION_SQUARE_BUTTON = 19
    PLAY_BUTTON = 20
    PAUSE_BUTTON = 21
    OUYA_BUTTON_O = 22
    OUYA_BUTTON_U = 23
    OUYA_BUTTON_Y = 24
    OUYA_BUTTON_A = 25
    TOKEN = 26
    LOGO = 27
    TICKET = 28
    GOOGLE_PLAY_GAMES_LOGO = 29
    GAME_CENTER_LOGO = 30
    DICE_BUTTON1 = 31
    DICE_BUTTON2 = 32
    DICE_BUTTON3 = 33
    DICE_BUTTON4 = 34
    GAME_CIRCLE_LOGO = 35
    PARTY_ICON = 36
    TEST_ACCOUNT = 37
    TICKET_BACKING = 38
    TROPHY1 = 39
    TROPHY2 = 40
    TROPHY3 = 41
    TROPHY0A = 42
    TROPHY0B = 43
    TROPHY4 = 44
    LOCAL_ACCOUNT = 45
    EXPLODINARY_LOGO = 46
    FLAG_UNITED_STATES = 47
    FLAG_MEXICO = 48
    FLAG_GERMANY = 49
    FLAG_BRAZIL = 50
    FLAG_RUSSIA = 51
    FLAG_CHINA = 52
    FLAG_UNITED_KINGDOM = 53
    FLAG_CANADA = 54
    FLAG_INDIA = 55
    FLAG_JAPAN = 56
    FLAG_FRANCE = 57
    FLAG_INDONESIA = 58
    FLAG_ITALY = 59
    FLAG_SOUTH_KOREA = 60
    FLAG_NETHERLANDS = 61
    FEDORA = 62
    HAL = 63
    CROWN = 64
    YIN_YANG = 65
    EYE_BALL = 66
    SKULL = 67
    HEART = 68
    DRAGON = 69
    HELMET = 70
    MUSHROOM = 71
    NINJA_STAR = 72
    VIKING_HELMET = 73
    MOON = 74
    SPIDER = 75
    FIREBALL = 76
    FLAG_UNITED_ARAB_EMIRATES = 77
    FLAG_QATAR = 78
    FLAG_EGYPT = 79
    FLAG_KUWAIT = 80
    FLAG_ALGERIA = 81
    FLAG_SAUDI_ARABIA = 82
    FLAG_MALAYSIA = 83
    FLAG_CZECH_REPUBLIC = 84
    FLAG_AUSTRALIA = 85
    FLAG_SINGAPORE = 86
    OCULUS_LOGO = 87
    STEAM_LOGO = 88
    NVIDIA_LOGO = 89
    FLAG_IRAN = 90
    FLAG_POLAND = 91
    FLAG_ARGENTINA = 92
    FLAG_PHILIPPINES = 93
    FLAG_CHILE = 94
    MIKIROG = 95
    V2_LOGO = 96
    CLOSE = 97
    SANTA_HAT = 98
    POTATO = 99
    PALM_TREE = 100
    BOXING_GLOVE = 101
