# Released under the MIT License. See LICENSE for details.
#
"""Text related bits."""

from __future__ import annotations
from enum import Enum

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    pass


class SpecialChar(Enum):
    """Custom unicode characters the engine can display.

    Keep this in sync with babase._mgen.enums.SpecialChar.
    """

    LEFT_ARROW = '\ue001'
    RIGHT_ARROW = '\ue002'
    UP_ARROW = '\ue003'
    DOWN_ARROW = '\ue004'
    LEFT_BUTTON = '\ue005'
    TOP_BUTTON = '\ue006'
    RIGHT_BUTTON = '\ue007'
    BOTTOM_BUTTON = '\ue008'
    DELETE = '\ue009'
    SHIFT = '\ue00a'
    BACK = '\ue00b'
    LOGO_FLAT = '\ue00c'
    REWIND_BUTTON = '\ue00d'
    PLAY_PAUSE_BUTTON = '\ue00e'
    FAST_FORWARD_BUTTON = '\ue00f'
    DPAD_CENTER_BUTTON = '\ue010'
    PLAY_STATION_CROSS_BUTTON = '\ue011'
    PLAY_STATION_CIRCLE_BUTTON = '\ue012'
    PLAY_STATION_TRIANGLE_BUTTON = '\ue013'
    PLAY_STATION_SQUARE_BUTTON = '\ue014'
    PLAY_BUTTON = '\ue015'
    PAUSE_BUTTON = '\ue016'
    CLOSE = '\ue017'
    OUYA_BUTTON_O = '\ue019'
    OUYA_BUTTON_U = '\ue01a'
    OUYA_BUTTON_Y = '\ue01b'
    OUYA_BUTTON_A = '\ue01c'
    TOKEN = '\ue01d'
    LOGO = '\ue01e'
    TICKET = '\ue01f'
    GOOGLE_PLAY_GAMES_LOGO = '\ue020'
    GAME_CENTER_LOGO = '\ue021'
    DICE_BUTTON1 = '\ue022'
    DICE_BUTTON2 = '\ue023'
    DICE_BUTTON3 = '\ue024'
    DICE_BUTTON4 = '\ue025'
    GAME_CIRCLE_LOGO = '\ue026'
    PARTY_ICON = '\ue027'
    TEST_ACCOUNT = '\ue028'
    TICKET_BACKING = '\ue029'
    TROPHY1 = '\ue02a'
    TROPHY2 = '\ue02b'
    TROPHY3 = '\ue02c'
    TROPHY0A = '\ue02d'
    TROPHY0B = '\ue02e'
    TROPHY4 = '\ue02f'
    LOCAL_ACCOUNT = '\ue030'
    EXPLODINARY_LOGO = '\ue031'
    FLAG_UNITED_STATES = '\ue032'
    FLAG_MEXICO = '\ue033'
    FLAG_GERMANY = '\ue034'
    FLAG_BRAZIL = '\ue035'
    FLAG_RUSSIA = '\ue036'
    FLAG_CHINA = '\ue037'
    FLAG_UNITED_KINGDOM = '\ue038'
    FLAG_CANADA = '\ue039'
    FLAG_INDIA = '\ue03a'
    FLAG_JAPAN = '\ue03b'
    FLAG_FRANCE = '\ue03c'
    FLAG_INDONESIA = '\ue03d'
    FLAG_ITALY = '\ue03e'
    FLAG_SOUTH_KOREA = '\ue03f'
    FLAG_NETHERLANDS = '\ue040'
    FEDORA = '\ue041'
    HAL = '\ue042'
    CROWN = '\ue043'
    YIN_YANG = '\ue044'
    EYE_BALL = '\ue045'
    SKULL = '\ue046'
    HEART = '\ue047'
    DRAGON = '\ue048'
    HELMET = '\ue049'
    MUSHROOM = '\ue04a'
    NINJA_STAR = '\ue04b'
    VIKING_HELMET = '\ue04c'
    MOON = '\ue04d'
    SPIDER = '\ue04e'
    FIREBALL = '\ue04f'
    FLAG_UNITED_ARAB_EMIRATES = '\ue050'
    FLAG_QATAR = '\ue051'
    FLAG_EGYPT = '\ue052'
    FLAG_KUWAIT = '\ue053'
    FLAG_ALGERIA = '\ue054'
    FLAG_SAUDI_ARABIA = '\ue055'
    FLAG_MALAYSIA = '\ue056'
    FLAG_CZECH_REPUBLIC = '\ue057'
    FLAG_AUSTRALIA = '\ue058'
    FLAG_SINGAPORE = '\ue059'
    OCULUS_LOGO = '\ue05a'
    STEAM_LOGO = '\ue05b'
    NVIDIA_LOGO = '\ue05c'
    FLAG_IRAN = '\ue05d'
    FLAG_POLAND = '\ue05e'
    FLAG_ARGENTINA = '\ue05f'
    FLAG_PHILIPPINES = '\ue060'
    FLAG_CHILE = '\ue061'
    MIKIROG = '\ue062'
    V2_LOGO = '\ue063'
    SANTA_HAT = '\ue064'
    POTATO = '\ue065'
    PALM_TREE = '\ue066'
    BOXING_GLOVE = '\ue067'
